/*+ TsipDemo.h
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file defines the main program class.
 *            
 * Revision History:
 *    05-18-2005    Mike Priven
 *                  Written
 *
 * Notes:
 *
-*/

#ifndef GPS_APP_MON_H
#define GPS_APP_MON_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
    #error include 'stdafx.h' before including this file for PCH
#endif


/*---------------------------------------------------------------------------*\
 |                         I N C L U D E   F I L E S
\*---------------------------------------------------------------------------*/
#include "resource.h"       // main symbols
#include "CommPort.h"       // a simple serial I/O package - minimal, really
#include "EnumSer.h"        // serial COM port enumerator
#include "MetaParser.h"

 
/*---------------------------------------------------------------------------*\
 |                             C O N S T A N T S
\*---------------------------------------------------------------------------*/
// Application version information
#define APP_VERSION    "1.1"
#define APP_NAME       "TSIP and NMEA Demo"
#define BUILD_DATE     __DATE__

// Application states
#define IDLE           0
#define TSIP           1


/*---------------------------------------------------------------------------*\
 |             F O R W A R D   C L A S S   D E C L A R A T I O N S
\*---------------------------------------------------------------------------*/
class CTsipWindow;


/*---------------------------------------------------------------------------*\
 |                      C L A S S   D E F I N I T I O N
\*---------------------------------------------------------------------------*/
class CMainApp : public CWinApp
{

public: //==== P U B L I C   M E M B E R   V A R I A B L E S =================/

    CTsipWindow *m_pMainWndDlg;


public: //==== P U B L I C   M E T H O D S ===================================/

    CMainApp(CString name);

    virtual BOOL InitInstance();
    virtual int ExitInstance();


protected: //==== P R O T E C T E D   M E T H O D S ==========================/

    DECLARE_MESSAGE_MAP()
};

#endif
